/* application source */
var canvas = document.getElementById("skeletonsCanvas");
var context = canvas.getContext("2d");

function getSkeletons(jsonObject){
	
  if (context == null) {
      return;
  }
  
  context.clearRect(0, 0, canvas.width, canvas.height);

  for (var i = 0; i < jsonObject.skeletons.length; i++) {
	var headZ = 0;
    var hipZ = 0;

    for (var j = 0; j < jsonObject.skeletons[i].joints.length; j++) 
    {
      var joint = jsonObject.skeletons[i].joints[j];
      
      // Draw!!!
      context.fillStyle = "#FF0000";
      context.beginPath();
      context.arc(joint.x, joint.y, 10, 0, Math.PI * 2, true);
      context.closePath();
      context.fill();
		
      // joint.name  values
      		//head
      		//hipleft
      
     }
	}
}

              
function msgFromArduino(value){
	console.debug('From Arduino: ' + value);
}

function next() {
	console.debug('Next!');  
}

function prior() {
	console.debug('Prior');
}

function noUser(){
  console.debug('No User :(');  
//sendToArduino('0');
  
}

function newUser() {
  console.debug('New User :)');  
  //sendToArduino('1');
}

function changeHandNone() {
	console.debug('Hand None');  
}

function changeHandRight() {
  	console.debug('Hand Right');  
}

function changeHandLeft() {
	console.debug('Hand Left');  
}
(function ($) {
    $.fn.mySlider = function () {
        var that = $(this);
        var childs = that.find("li");
        var collection = [];
        var position = 0;
        var timeoutId;
        var valor = 0;
       	var listQR = ["images/QR0.png","images/QR1.png","images/QR2.png","images/QR3.png"];
        var listDescriptions = ["<ul><li><strong>Descripción:</strong> piso en Puerta de Hierro, 447.00 m2, 6 dormitorios, 4 baños, exterior, orientación norte, 3 plazas de garaje. </li><li><strong>Precio:  <span style='font-size:larger'>800.000€</span> </strong></li></ul>", "<ul ><li><strong>Descripción:</strong> expectacular piso en la finca más cotizada del barrio. Terraza, 7 habitaciones, 5 baños. Muy exclusivo. </li><li><strong>Precio:  <span style='font-size:larger'>1.500.000€</span> </strong></li></ul>", "<ul ><li><strong>Descripción:</strong> piso ideal para una pareja. 1 baño, 3 habitaciones y un pequeño balcón. Está cerca de estación de metro y autobús.</li><li><strong>Precio:  <span style='font-size:larger'>300.000€</span> </strong></li></ul>", "<ul ><li><strong>Descripción:</strong> San Francisco de Sales. Piso para reformar con muchas posibilidades. Todo el exterior ajardinado.</li><li><strong>Precio:  <span style='font-size:larger'>700.000€</span> </strong></li></ul>"];
         init();

        //**********CREATE ARROWS, FIRST BACKGROUND, TIME BAR AND NAVIGATOR*******
        function init() {
            var num_pic = childs.length;
            inicializeCursor();
            addAllElements();
        }

        //********** GET POSITION OF NEW IMAGE *********
        function change_img_to(direction) {
            var old_position = position;
            //********RIGHT**************
            if (direction == "right") {
                if (position >= collection.length - 1) {
                    position = 0;
                } else {
                    position = (position % collection.length) + 1;
                }
            }

            //********LEFT*****************
            if (direction == "left") {
                if (position < 1) {
                    position = collection.length - 1;
                } else {
                    position = (position % collection.length) - 1;
                }
            }
            refresh_QR_and_BK_and_desc();
            refresh_navigator(position, old_position);
        }


        //***********TO RIGHT***************
        function to_right() {
            that.parent().toggle("slide", {
                direction: 'left',
                duration: 400
            });

            setTimeout(function () {
                change_img_to("right");
                that.parent().toggle("slide", {
                    direction: 'right'
                });

            }, 400);
        }

        //*************TO LEFT**********
        function to_left() {
            that.parent().toggle("slide", {
                direction: 'right',
                duration: 400
            });

            setTimeout(function () {
                change_img_to("left");
                that.parent().toggle("slide", {
                    direction: 'left'
                });

            }, 400);
        }


        $('body').mouseenter(function () {
            $('#mycursor').show();
        });

        $('body').mousemove(function (e) {
            $('#mycursor').css('left', e.clientX - 20).css('top', e.clientY + 7);
        });


        //*********** MOUSE LEAVE************
        $("#right").mouseleave(function () {
            $("#right").fadeTo(0, 0.5);
            $('#mycursor.hover').css("background-image", "url('http://icons.iconarchive.com/icons/icons8/ios7/256/Hands-Whole-Hand-icon.png')");

        });

        $("#left").mouseleave(function () {
            $("#left").fadeTo(0, 0.5);
            $('#mycursor.hover').css("background-image", "url('http://icons.iconarchive.com/icons/icons8/ios7/256/Hands-Whole-Hand-icon.png')");
        });

        $(".circle").mouseleave(function () {
            $('#mycursor.hover').css("background-image", "url('http://icons.iconarchive.com/icons/icons8/ios7/256/Hands-Whole-Hand-icon.png')");
        })


        //*********** MOUSE HOVER************

        $("#right").hover(function () {
            $("#right").fadeTo(0, 1);
            $('#mycursor').addClass('hover');
            $('#mycursor.hover').css("background-image", "url('https://cdn2.iconfinder.com/data/icons/seo-web-optomization-ultimate-set/512/time_efficiency-512.png')");

            if (!timeoutId) {
                timeoutId = window.setTimeout(function () {
                    timeoutId = null;
                    to_right();
                }, 500);
            }

        }, function () {
            if (timeoutId) {
                window.clearTimeout(timeoutId);
                timeoutId = null;
            }
        });

        $("#left").hover(function () {
            $("#left").fadeTo(0, 1);
            $('#mycursor').addClass('hover');
            $('#mycursor.hover').css("background-image", "url('https://cdn2.iconfinder.com/data/icons/seo-web-optomization-ultimate-set/512/time_efficiency-512.png')");

            if (!timeoutId) {
                timeoutId = window.setTimeout(function () {
                    timeoutId = null;
                    to_left();
                }, 500);
            }

        }, function () {
            if (timeoutId) {
                window.clearTimeout(timeoutId);
                timeoutId = null;
            }
        });

        $(".circle").hover(function () {
            $('#mycursor').addClass('hover');
            $('#mycursor.hover').css("background-image", "url('https://cdn2.iconfinder.com/data/icons/seo-web-optomization-ultimate-set/512/time_efficiency-512.png')");

            if (!timeoutId) {
                var num = $(this).children().attr('id');
                timeoutId = window.setTimeout(function () {
                    timeoutId = null;
                    navigator(num);
                    refresh_navigator(num, position);
                    $(this).css("background", "white");
                    $(this).css("color", "black");
                }, 500);
            }
        }, function () {
            if (timeoutId) {
                window.clearTimeout(timeoutId);
                window.clearTimeout(timeoutId);
                timeoutId = null;
            }
        });


        jQuery("#description").fitText(1.7);

        //************************AUXILARY FUNCTIONS*********************************
        function to_number(number) {
            that.parent().css("background-image", 'url(' + collection[number] + ')');
            $("#QR").css("background-image", "url('" + listQR[number] + "')");
            $("#description").html('</br>' + listDescriptions[number]);

            position = number;
            valor = 0;
        }

        function navigator(number) {
            that.parent().toggle("slide", {
                direction: 'left',
                duration: 400
            });
            setTimeout(function () {
                to_number(number)
                that.parent().toggle("slide", {
                    direction: 'right'
                });
            }, 400);
        }

        function inicializeCursor() {
            $('#mycursor').css("background-image", "url('http://icons.iconarchive.com/icons/icons8/ios7/256/Hands-Whole-Hand-icon.png')");
            that.hide();
        }

        function addAllElements() {
            var ulAmazingSlider = that.parent();
            childs.each(function (i, that) {
                collection.push($(that).find("img").attr("src"));
            });
            ulAmazingSlider.css("background-image", 'url(' + collection[0] + ')');

            //Add the progressbar, QR, and Arrows
            ulAmazingSlider.append("<div id='QR'></div><div id='progressbar'></div> <div class='arrow'><span id='left'><</span><span id='right'>></span></div><div class='nav'></div><div id='prizeAndDescription'><div id='logo'></div><div id='description'></div></div>");
            $("#QR").css("background-image", "url('" + listQR[0] + "')");
          
          $("#logo").css("background-image", "url('http://cdn6.albertoggago.es/wp-content/uploads/2014/12/orange-logo-2.jpg')");
            //$("#logo").css("background-image", "url('http://www.gilmar.es/img/gilmar_logo.jpg')");
            $(".arrow").css("color", "white");

            //Add the navigator
            for (var i = 0; i < collection.length; i++) {
                $(".nav").append("<div class='circle' ><div id=" + i + " class='contentCircle'>····</div></div>");
                $("#left").fadeTo(0, 0.5);
                $("#right").fadeTo(0, 0.5);
                $('#' + position).css("background", "white");
                $('#' + position).css("color", "white");
            }
            $("#description").append('<br>' + listDescriptions[0])
        }

        $(function move_bar() {
            $("#progressbar").progressbar({
                max: 100,
                value: valor,
                complete: function () {
                    clearInterval(int);
                }
            });

            function incrementProgressBar() {
                valor++;
                if (valor > 99) {
                    to_right();
                    valor = 0;
                }
                $("#progressbar").progressbar("value", valor);
            }
            var int = setInterval(incrementProgressBar, 50);
        });

        function refresh_navigator(pos, old_pos) {
            $('#' + old_pos).css("background", "black");
            $('#' + old_pos).css("color", "black");
            $('#' + pos).css("background", "white");
            $('#' + pos).css("color", "white");
        }

        function refresh_QR_and_BK_and_desc() {
            valor = 0;
            that.parent().css("background-image", 'url(' + collection[position] + ')');
            $("#QR").css("background-image", "url('" + listQR[position] + "')");
            $("#description").html('</br>' + listDescriptions[position]);
        }
    };
}(jQuery));



$(document).ready(function () {
    $(".amazingSlider").mySlider();
});
