/* application source */
var canvas = document.getElementById("skeletonsCanvas");
var context = canvas.getContext("2d");

function getSkeletons(jsonObject) {
	
  if (context == null) {
      return;
  }
  
  context.clearRect(0, 0, canvas.width, canvas.height);

  for (var i = 0; i < jsonObject.skeletons.length; i++) {
	var headZ = 0;
    var hipZ = 0;

    for (var j = 0; j < jsonObject.skeletons[i].joints.length; j++) 
    {
      var joint = jsonObject.skeletons[i].joints[j];
      
      // Draw!!!
      context.fillStyle = "#FF0000";
      context.beginPath();
      context.arc(joint.x, joint.y, 10, 0, Math.PI * 2, true);
      context.closePath();
      context.fill();
		
      // joint.name  values
      		//head
      		//hipleft
      
     }
	}
}

              
function msgFromArduino(value){
	console.debug('From Arduino: ' + value);
}

function next() {
	if(isNotHome()){
      	$('.fp-prev').click();
    }
}

function prior() {
	if(isNotHome()){
      	$('.fp-next').click();
    }
}

function isNotHome(){
	var elementName = $('#menu').find('li.active').first().attr('data-menuanchor');
    return elementName != 'Home';
}

function grip() {
	console.debug('Grip!');  
}

function release() {
	console.debug('Release');
}

function noUser(){
  console.debug('No User :(');  
//sendToArduino('0');
  
}

function newUser() {
  console.debug('New User :)');  
  //sendToArduino('1');
}

function changeHandNone() {
	console.debug('Hand None');  
}

function changeHandRight() {
  	console.debug('Hand Right');  
}

function changeHandLeft() {
	console.debug('Hand Left');  
}


ubiquo = function(){
    var controls ={
	click:"Ubi---click",
	loaded:"Ubi---loaded"
    };

    var cursorInterval;
    var cursorIntervalWidth=0;
    var cursorStart = function(){
	var LoadingExists = document.getElementById("ubiCursorLoading");

	if(LoadingExists===null){
	    var body  = document.getElementsByTagName("body").item(0);
	    var myDiv= document.createElement("div");
	    myDiv.id="ubiCursorLoading";
	    myDiv.style.position="fixed";
	    myDiv.style.bottom="0px";
	    myDiv.style.right="0px";
	    myDiv.style.width="0px";
	    myDiv.style.height="30px";
      myDiv.style.zIndex="99999";
	    myDiv.style.backgroundColor="black";

	    body.appendChild(myDiv);
	}
	cursorInterval = setInterval(function(){
	    cursorIntervalWidth+=1;
	    var LoadingExists = document.getElementById("ubiCursorLoading");
	    LoadingExists.style.width=cursorIntervalWidth+"%";
	    
	},20);
	
    };
    
    var cursorEnd = function(){
	var LoadingExists = document.getElementById("ubiCursorLoading");
	cursorIntervalWidth=0;
	clearTimeout(cursorInterval);
	LoadingExists.style.width=cursorIntervalWidth+"px";
	
    };
    
    
    
    var hasClass= function (element, cls) {
	return (' ' + element.className + ' ').indexOf(' ' + cls + ' ') > -1;
    };
    
  function eventFire(el, etype){
    if (el.fireEvent) {
      el.fireEvent('on' + etype);
    } else {
      var evObj = document.createEvent('Events');
      evObj.initEvent(etype, true, false);
      el.dispatchEvent(evObj);
    }
  }
  
    var prepareClick = function(element){	
	cursorStart();
	this.ubiready = setTimeout(function(that){
      
	    return function(){
		eventFire(that,"click");
		cursorEnd();
	    };
	}(this),400);
    };
    
  
    
    var loadMouseOver = function(element){

	element.addEventListener("mouseover",function(){
	    prepareClick.apply(this);
	});
	element.addEventListener("mouseout",function(){
	    clearTimeout(this.ubiready);
	    cursorEnd();
	});
    };
    
    var initEvent = function(elements){
	for (var i in elements){
	    if(!hasClass(elements[i],controls.loaded) && typeof elements[i] ==="object"){
		elements[i].className = elements[i].className + " " +controls.loaded;
		loadMouseOver(elements[i]);
	    }
	}
    };
    
    var load = function(){
	var elementCollection = document.getElementsByClassName(controls.click);
	initEvent(elementCollection);
    };
    
    return{
	load:load
    };
    
}();

(function($) {
 
          $.fn.mySlider = function() {
               $('#mycursor').show();
               $('#mycursor').css("background-image", "url('images/cursor.png')");
               $('body').mousemove(function(e) {
                 
              $('#mycursor').css('left', e.clientX - 20).css('top', e.clientY + 7);
                 
                 if({parameter:26} == 1)
                 {
                   $('h1').text(e.clientX);
                   
                 }
               
                 
               });
            
           };
       }(jQuery));

       $(document).ready(function() {
           $("body").mySlider();
         
         if({parameter:26} == 0)
                 {
                   $('h1').hide();
                   
                 }
         
       });

/* CODIGO BARRA MENU */

/* FIN CODIGO BARRA MENU */
