/* application source */

//Global variables
var BubbleExplodeTime = 500; // Time to expload bubble. Time in second.
var CopyTextShowTime = 5; // Copy box show. Time in second.
var BubbleTimeoutExploding =1500;

var cursorRight = true;
var cursorLeft = false;
var isChangingHand = false;
var isNoUser = true;

var pause1 = false;
var pause2 = false;
var pause3 = false;
var pause4 = false;
var pause5 = false;
var pause6 = false;
var pause7 = false;
var pause8 = false;
var pause9 = false;
var last_bubble = null;
var do_or_not = 1;
var init = 0;
var identifier;
var refreshId;
var hold = 0;

var timeout = null;
var timeoutHover = null;
mouseHasBeenMoved = {'hasMoved': false};

    var canvas = document.getElementById("skeletonsCanvas");
    var context = canvas.getContext("2d");

function getSkeletons(jsonObject){
  
  
  
  if (context == null) {
      return;
  }
  try{
    if(recorder.recording){
      recorder.saveStep(jsonObject);
    }
  }catch(err){
  
  }
  
  context.clearRect(0, 0, canvas.width, canvas.height);

  for (var i = 0; i < jsonObject.skeletons.length; i++) {
	var headZ = 0;
    var hipZ = 0;

    //draw head
    var head = jsonObject.skeletons[i].joints[6];
    
    //http://www.codeproject.com/KB/dotnet/KinectGettingStarted/7.png
  //------------------------
  //[0] handright
  //[1] elbowright
  //[2] shoulderright
  //[3] handleft
  //[4] elbowleft
  //[5] shoulderleft
  //[6] head
  //[7] spineneck
  //[8] spinecenter
  //[9] hipcenter
  //[10] kneeleft
  //[11] kneeright
  //[12] ankleleft
  //[13] ankleright
    
    var shouldercenter = jsonObject.skeletons[i].joints[7];
    var shoulderleft = jsonObject.skeletons[i].joints[5];
    var shoulderright = jsonObject.skeletons[i].joints[2];
    var elbowright = jsonObject.skeletons[i].joints[1];
    var elbowleft = jsonObject.skeletons[i].joints[4];
    var handright = jsonObject.skeletons[i].joints[0];
    var handleft = jsonObject.skeletons[i].joints[3];
    //var wristright = jsonObject.skeletons[i].joints[10];
    //var wristleft = jsonObject.skeletons[i].joints[6];
    var hipcenter = jsonObject.skeletons[i].joints[9];
    var kneeleft = jsonObject.skeletons[i].joints[10];
    var kneeright = jsonObject.skeletons[i].joints[11];    
    var ankleleft = jsonObject.skeletons[i].joints[12];    
    var ankleright = jsonObject.skeletons[i].joints[13];    
    
    context.fillStyle = "#000000";
    context.strokeStyle = '#000000'; 
    context.lineWidth = 10;
	
    
    context.beginPath()
    context.arc(head.x, head.y, 20, 0, Math.PI * 2, true);
    context.closePath()
    context.fill();	
    context.stroke(); 
    
    context.beginPath()
   		context.moveTo(head.x, head.y);
		context.lineTo(shouldercenter.x, shouldercenter.y);
    context.closePath()
    context.stroke(); 

    
    context.beginPath()
   		context.moveTo(shouldercenter.x, shouldercenter.y);
		context.lineTo(elbowright.x, elbowright.y);	    
    context.closePath()
    context.stroke(); 

   context.beginPath()
   		context.moveTo(elbowright.x, elbowright.y);
		context.lineTo(handright.x, handright.y);	    
    context.closePath()
    context.stroke(); 

    
   context.beginPath()
    	context.moveTo(shouldercenter.x, shouldercenter.y);
    	context.lineTo(elbowleft.x, elbowleft.y);
    context.closePath()
    context.stroke(); 

    context.beginPath()
   		context.moveTo(elbowleft.x, elbowleft.y);
		context.lineTo(handleft.x, handleft.y);	    
    context.closePath()
    context.stroke(); 
    
    context.beginPath()
    	context.moveTo(shouldercenter.x, shouldercenter.y);
    	context.lineTo(hipcenter.x, hipcenter.y);
    context.closePath()
    context.stroke(); 

    context.beginPath()
    	context.moveTo(hipcenter.x, hipcenter.y);
    	context.lineTo(kneeleft.x, kneeleft.y);    
    context.closePath()
    context.stroke(); 

    context.beginPath()
    	context.moveTo(kneeleft.x, kneeleft.y);
    	context.lineTo(ankleleft.x, ankleleft.y);    
    context.closePath()
    context.stroke(); 
    
    
    context.beginPath()
    	context.moveTo(hipcenter.x, hipcenter.y);
    	context.lineTo(kneeright.x, kneeright.y);    
     context.closePath()
    context.stroke(); 

    context.beginPath()
    	context.moveTo(kneeright.x, kneeright.y);
    	context.lineTo(ankleright.x, ankleright.y);    
    context.closePath()
    context.stroke(); 

    
    
    

    /*
    context.beginPath()
    context.arc(shoulderLeft.x, shoulderLeft.y, 20, 0, Math.PI * 2, true);
    context.closePath()
    context.fill();	
    context.stroke(); 
    
    context.beginPath()
    context.arc(shoulderRight.x, shoulderRight.y, 20, 0, Math.PI * 2, true);    
    context.closePath()
    context.fill();	
    context.stroke(); 

	*/
    
    
    
    
    /*for (var j = 0; j < jsonObject.skeletons[i].joints.length; j++) 
    {
      var joint = jsonObject.skeletons[i].joints[j];

      context.fillStyle = "#EC8B38";
      context.beginPath();
      context.arc(joint.x, joint.y, 10, 0, Math.PI * 2, true);
      context.closePath();
      context.fill();	
      
     }*/
	}
}
              
function msgFromArduino(value){
	console.debug('From Arduino: ' + value);
}

function next() {
	console.debug('Next!');  
}

function prior() {
	console.debug('Prior');
}

function manageUserPresence(isPresent){

      if(isPresent){
			$('#cursor_pointer').show();
			isNoUser = false;
    	}else{
			isNoUser = true;
			$('#cursor_pointer').hide();
    }

}

function noUser(){
  manageUserPresence(false);
   console.debug('New User :)');  
 //var xmlHttp = new XMLHttpRequest();
  //  xmlHttp.open( "GET", 'http://192.168.1.60/green.act', false ); // false for synchronous request
   // xmlHttp.send( null );
}

function newUser() {
    showCopy();
  manageUserPresence(false);
    manageUserPresence(true);
	
    var timeOutCopy = setTimeout(function() {
        hideCopy();
    }, 5000);

    mouseHasBeenMoved.watch('hasMoved', function() {
        if (mouseHasBeenMoved.hasMoved == true) {
            clearTimeout(timeOutCopy);
            hideCopy();
            mouseHasBeenMoved.unwatch('hasMoved');
            mouseHasBeenMoved.hasMoved = false;
        }
    });
  
   //var xmlHttp = new XMLHttpRequest();
   // xmlHttp.open( "GET", 'http://192.168.1.60/red.act', false ); // false for synchronous request
   // xmlHttp.send( null );
  
   console.debug('New User :)');  
  
  
}

function updateApp() {
    window.open("uloading.html", "_self")
}

function changeHandNone() {
  $('#cursor_pointer').hide();
}


function changeHandRight() {
  $('#cursor_pointer').show();
	isChangingHand = true;
    $('.cursor_pointer').hide();
    $('#cursor_pointer img').hide();
    cursorRight = true;
    cursorLeft = false;
    $('.cursor_right_anim').show();

    setTimeout(function() {
		isChangingHand = false;
        $('#cursor_pointer img').hide();
        $('.cursor_right_anim').hide();
        $('.cursor_right').show();

    }, 1500);
}

function changeHandLeft() {
  $('#cursor_pointer').show();
	isChangingHand = true;
	$('.cursor_pointer').hide();
    $('#cursor_pointer img').hide();
    cursorLeft = true;
    cursorRight = false;
    $('.cursor_left_anim').show();
    setTimeout(function() {
		isChangingHand = false;
        $('#cursor_pointer img').hide();
        $('.cursor_left_anim').hide();
        $('.cursor_left').show();
    }, 1500);
}


function mse(e) {
    if (window.event) {
        var docs = [document.body.scrollLeft, document.body.scrollTop];
        if (!document.body.scrollTop) {
            docs = [document.documentElement.scrollLeft, document.documentElement.scrollTop];
        }
        return [e.clientX + docs[0], e.clientY + docs[1]];
    }
    return [e.pageX, e.pageY];
}

document.onmousemove = function(e) {

  $('#cursor_pointer').removeClass('hideCursor');

    e = e || window.event;
    var m = mse(e);
    handPos(m[0], m[1]);
}


function handPos(x, y) {
    var all = document.getElementById("cursor_pointer");
    all.style.left = x + "px";
    all.style.top = y + "px";
    hideCopy();

    mouseHasBeenMoved.hasMoved = true;
}

function hideCopy() {
    $('.copy-back').fadeOut(500);
}

function showCopy() {
    $('.copy-back').delay(1000).fadeIn(500);
}

function setTimeoutHoverContent() {
    mouseFront();
    timeoutHover = setTimeout(function() {
        mouseBack();
        closed();
    }, BubbleTimeoutExploding);
}

function manageHoverContent(indexBubble) {
  
   if(isNoUser){
        clearTimeout(timeoutHover);
        mouseBack();
        closed();
   }

    /*var selector = '#' + indexBubble + '_bubble_content';
    $(selector + ' .twitter').mouseenter(function() {
        clearTimeout(timeoutHover);
    });

    $(selector + ' .twitter').mouseleave(function() {
        setTimeoutHoverContent();
    });

    $(selector).find('.facebook').mouseenter(function() {
        clearTimeout(timeoutHover);
    });

    $(selector).find('.facebook').mouseleave(function() {
        setTimeoutHoverContent();
    });*/
  
   setTimeoutHoverContent();
}

function restoreCursorHover() {

if(!isChangingHand){
$('.cursor_pointer').hide();
    if (cursorRight) {
        $('.cursor_right').show();
    } else {
        $('.cursor_left').show();
    }
}    
}

function manageCursorHover(initCursor) {

if(!isChangingHand ){

    var currentPercentage = (initCursor / BubbleExplodeTime) * 100;

    if (currentPercentage > 0) {
        $('.cursor_pointer').hide();

        if (currentPercentage >= 10 && currentPercentage <= 40) {
            if (cursorRight) {
                $('.cursor_right33').show();
            } else {
                $('.cursor_left33').show();
            }
        }
        else if (currentPercentage >= 50 && currentPercentage <= 70) {
            if (cursorRight) {
                $('.cursor_right66').show();
            } else {
                $('.cursor_left66').show();
            }
        } else if (currentPercentage >= 70 && currentPercentage <= 150) {
            if (cursorRight) {
                $('.cursor_rightfull').show();
            } else {
                $('.cursor_leftfull').show();
            }
        }
    }
}
}

$('.overlay-1, .overlay-2 , .overlay-3, .overlay-4, .overlay-5, .overlay-6, .overlay-7, .overlay-8, .overlay-9').hover(function() {
 if(!isNoUser){

    var identifier = $(this).attr("id");
    var progressStep = BubbleExplodeTime/3;
    do_or_not = 1;
    init = 0;
    refreshId = setInterval(function() {
        if (do_or_not == 1) {
            manageCursorHover(init);
            if (init >= BubbleExplodeTime) {
                restoreCursorHover();
                clearInterval(refreshId);
                $(".overlay-2-cover").show(0);
                hold = 1;
                pause1 = true;
                pause2 = true;
                pause3 = true;
                pause4 = true;
                pause5 = true;
                pause6 = true;
                pause7 = true;
                pause8 = true;
                pause9 = true;
                $('#copy').hide();
                $("#js-move-" + identifier).hide("explode");
                $(".overlay-" + identifier).hide("explode");
                $("#js-move-" + identifier).find('.back').hide("explode", function() {
                    $('#msg_holder').html($(".overlay-" + identifier + "-details").html());
                    manageHoverContent(identifier);
                });
                clearInterval(refreshId);
            }
        }
        init = init + progressStep;
    }, progressStep);
}
}, function() {
if(!isNoUser){
    clearInterval(refreshId);
    restoreCursorHover();
    do_or_not = 0;
    init = 0;
    identifier = '';
    last_bubble = '';
}
});

function closed($this) {
    pause1 = false;
    pause2 = false;
    pause3 = false;
    pause4 = false;
    pause5 = false;
    pause6 = false;
    pause7 = false;
    pause8 = false;
    pause9 = false;

    for (i = 1; i <= 9; i++) {
        $("#js-move-" + i).show("explode");
        $(".overlay-" + i).show("explode");
        $("#js-move-" + i).find('.back').show("explode");
    }
    $('#copy').show();
    $('#msg_holder').html('');
    $(".overlay-2-cover").hide();
    hold = 0;
};

function mouseFront() {
    $('#cursor_pointer').addClass('cursor_fore');
}

function mouseBack() {
    $('#cursor_pointer').removeClass('cursor_fore');
}

//Mouse Over Glow
$('.fore-first-bubble, .tff_bubble, .tsz_bubble').mouseover(function() {
    $(this).find('div.back').addClass('opacity_sevnty');
    pause1 = true;
    pause2 = true;
    pause3 = true;
    pause4 = true;
    pause5 = true;
    pause6 = true;
    pause7 = true;
    pause8 = true;
    pause9 = true;
});
$('.fore-first-bubble, .tff_bubble, .tsz_bubble').mouseout(function() {
    $(this).find('div.back').removeClass('opacity_sevnty');
    pause1 = false;
    pause2 = false;
    pause3 = false;
    pause4 = false;
    pause5 = false;
    pause6 = false;
    pause7 = false;
    pause8 = false;
    pause9 = false;
});

// Move Bubble Function

var bbupstep = 3;

function float_bubble1(ele, wave, w_speed, from, to, f_t_speed, first_position) {

    var $this = $(ele); //The element for action put on
    i = 0; // Wave possition default
    wave_high = wave; // High Wave
    wave_low = -wave; // Low wave
    flag = true; // Flag condition to reverse wave
    bottom = from; // Starting bottom Possition
    up_speed = f_t_speed; // Speed of going up
    default_pos = first_position;

    fillBubble(1);

    setInterval(function() { // Up 	
        if (pause1 != true) {
            $this.css('bottom', default_pos);
            $('.overlay-1').css('bottom', default_pos);
            default_pos+=bbupstep;
            if (default_pos == to) {
                fillBubble(1);
                default_pos = bottom;
            }
        }
    }, up_speed);

    setInterval(function() { // Wave
        if (pause1 != true) {
            if (flag == true) {
                i++;
                $this.css('margin-left', i);
                $('.overlay-1').css('margin-left', i + 89);
                if (i == wave_high) {
                    flag = false;
                }
                ;
            } else {
                i--;
                $('.overlay-1').css('margin-left', i + 89);
                $this.css('margin-left', i);
                if (i == wave_low) {
                    flag = true;
                }
                ;
            }
        }
    }, w_speed);

//	$this.mouseover(function(){ pause1=true;  });
//	$this.mouseout(function(){ pause1=false;  });
}
function float_bubble2(ele2, wave2, w_speed2, from2, to2, f_t_speed2, first_position) {

    var $this2 = $(ele2); //The element for action put on
    i2 = 0; // Wave possition default
    wave_high2 = wave2; // High Wave
    wave_low2 = -wave2; // Low wave
    flag2 = true; // Flag condition to reverse wave
    bottom2 = from2; // Starting bottom Possition
    up_speed2 = f_t_speed2; // Speed of going up
    default_pos2 = first_position;

    fillBubble(2);

    setInterval(function() { // Up 	
        if (pause2 != true) {
            $this2.css('top', default_pos2);
            $('.overlay-2').css('top', default_pos2);
            default_pos2-=bbupstep;
            if (default_pos2 == to2) {
                fillBubble(2);
                default_pos2 = bottom2;
            }
        }
    }, up_speed2);

    setInterval(function() { // Wave
        if (pause2 != true) {
            if (flag2 == true) {
                $this2.css('margin-left', i2);
                $('.overlay-2').css('margin-left', i2 + 219);
                //$('#test').html(i2);
                i2++;
                if (i2 == wave_high2) {
                    flag2 = false;
                }
                ;
            } else {
                //$('#test').html(i2);
                $this2.css('margin-left', i2);
                $('.overlay-2').css('margin-left', i2 + 219);
                i2--;
                if (i2 == wave_low2) {
                    flag2 = true;
                }
                ;
            }
        }
    }, w_speed2);
}
function float_bubble3(ele3, wave3, w_speed3, from3, to3, f_t_speed3, first_position) {

    fillBubble(3);

    var $this3 = $(ele3); //The element for action put on
    i3 = 0; // Wave possition default
    wave_high3 = wave3; // High Wave
    wave_low3 = -wave3; // Low wave
    flag3 = true; // Flag condition to reverse wave
    bottom3 = from3; // Starting bottom Possition
    up_speed3 = f_t_speed3; // Speed of going up
    default_pos3 = first_position;

    setInterval(function() { // Up 	
        if (pause3 != true) {
            $this3.css('bottom', default_pos3);
            $('.overlay-3').css('bottom', default_pos3);
            default_pos3+=bbupstep;
            if (default_pos3 == to3) {
                fillBubble(3);
                default_pos3 = bottom3;
            }
        }
    }, up_speed3);

    setInterval(function() { // Wave
        if (pause3 != true) {
            if (flag3 == true) {
                i3++;
                $('#js-move-3').css('margin-right', i3);
                $('.overlay-3').css('margin-right', i3 + 128);
                if (i3 == wave_high3) {
                    flag3 = false;
                }
                ;
            } else {
                i3--;
                $('#js-move-3').css('margin-right', i3);
                $('.overlay-3').css('margin-right', i3 + 128);
                if (i3 == wave_low3) {
                    flag3 = true;
                }
                ;
            }
        }
    }, w_speed3);
}
function float_bubble4(ele4, wave4, w_speed4, from4, to4, f_t_speed4, first_position) {

    fillBubble(4);

    var $this4 = $(ele4); //The element for action put on
    i4 = 0; // Wave possition default
    wave_high4 = wave4; // High Wave
    wave_low4 = -wave4; // Low wave
    flag4 = true; // Flag condition to reverse wave
    bottom4 = from4; // Starting bottom Possition
    up_speed4 = f_t_speed4; // Speed of going up
    default_pos4 = first_position;

    setInterval(function() { // Up 	
        if (pause4 != true) {
            $this4.css('top', default_pos4);
            $('.overlay-4').css('top', default_pos4);
            default_pos4-=bbupstep;
            if (default_pos4 == to4) {
                fillBubble(4);
                default_pos4 = bottom4;
            }
        }
    }, up_speed4);

    setInterval(function() { // Wave
        if (pause4 != true) {
            if (flag4 == true) {
                $('#js-move-4').css('margin-right', i4);
                $('.overlay-4').css('margin-right', i4 + 128);
                //$('#test').html(i4);
                i4++;
                if (i4 == wave_high4) {
                    flag4 = false;
                }
                ;
            } else {
                //$('#test').html(i4);
                $('#js-move-4').css('margin-right', i4);
                $('.overlay-4').css('margin-right', i4 + 128);
                i4--;
                if (i4 == wave_low4) {
                    flag4 = true;
                }
                ;
            }
        }
    }, w_speed4);
}
function float_bubble5(ele5, wave5, w_speed5, from5, to5, f_t_speed5, first_position) {

    var $this5 = $(ele5); //The element for action put on
    i5 = 0; // Wave possition default
    wave_high5 = wave5; // High Wave
    wave_low5 = -wave5; // Low wave
    flag5 = true; // Flag condition to reverse wave
    bottom5 = from5; // Starting bottom Possition
    up_speed5 = f_t_speed5; // Speed of going up
    default_pos5 = first_position;

    fillBubble(5);

    setInterval(function() { // Up 	
        if (pause5 != true) {
            $this5.css('top', default_pos5);
            $('.overlay-5').css('top', default_pos5);
            default_pos5-=bbupstep;
            if (default_pos5 == to5) {
                fillBubble(5);
                default_pos5 = bottom5;
            }
        }
    }, up_speed5);

    setInterval(function() { // Wave
        if (pause5 != true) {
            if (flag5 == true) {
                $('#js-move-5').css('margin-right', i5);
                $('.overlay-5').css('margin-right', i5 + 50);
                //$('#test').html(i5);
                i5++;
                if (i5 == wave_high5) {
                    flag5 = false;
                }
                ;
            } else {
                //$('#test').html(i5);
                $('#js-move-5').css('margin-right', i5);
                $('.overlay-5').css('margin-right', i5 + 50);
                i5--;
                if (i5 == wave_low5) {
                    flag5 = true;
                }
                ;
            }
        }
    }, w_speed5);
}
function float_bubble6(ele6, wave6, w_speed6, from6, to6, f_t_speed6, first_position) {

    var $this6 = $(ele6); //The element for action put on
    i6 = 0; // Wave possition default
    wave_high6 = wave6; // High Wave
    wave_low6 = -wave6; // Low wave
    flag6 = true; // Flag condition to reverse wave
    bottom6 = from6; // Starting bottom Possition
    up_speed6 = f_t_speed6; // Speed of going up
    default_pos6 = first_position;
    fillBubble(6);

    setInterval(function() { // Up 	
        if (pause6 != true) {
            $this6.css('top', default_pos6);
            $('.overlay-6').css('top', default_pos6);
            default_pos6-=bbupstep;
            if (default_pos6 == to6) {
                fillBubble(6);
                default_pos6 = bottom6;
            }
        }
    }, up_speed6);

    setInterval(function() { // Wave
        if (pause6 != true) {
            if (flag6 == true) {
                $('#flt-6').css('margin-left', i6);
                $('.overlay-6').css('margin-left', i6);
                //$('#test').html(i6);
                i6++;
                if (i6 == wave_high6) {
                    flag6 = false;
                }
                ;
            } else {
                //$('#test').html(i6);
                $('#flt-6').css('margin-left', i6);
                $('.overlay-6').css('margin-left', i6);
                i6--;
                if (i6 == wave_low6) {
                    flag6 = true;
                }
                ;
            }
        }
    }, w_speed6);
}
function float_bubble7(ele7, wave7, w_speed7, from7, to7, f_t_speed7, first_position) {

    var $this7 = $(ele7); //The element for action put on
    i7 = 0; // Wave possition default
    wave_high7 = wave7; // High Wave
    wave_low7 = -wave7; // Low wave
    flag7 = true; // Flag condition to reverse wave
    bottom7 = from7; // Starting bottom Possition
    up_speed7 = f_t_speed7; // Speed of going up
    default_pos7 = first_position;
    fillBubble(7);

    setInterval(function() { // Up 	
        if (pause7 != true) {
            $this7.css('bottom', default_pos7);
            $('.overlay-7').css('bottom', default_pos7);
            default_pos7+=bbupstep;
            if (default_pos7 == to7) {
                fillBubble(7);
                default_pos7 = bottom7;
            }
        }
    }, up_speed7);

    setInterval(function() { // Wave
        if (pause7 != true) {
            if (flag7 == true) {
                i7++;
                $('#flt-7').css('margin-left', i7);
                $('.overlay-7').css('margin-left', i7);
                if (i7 == wave_high7) {
                    flag7 = false;
                }
                ;
            } else {
                i7--;
                $('#flt-7').css('margin-left', i7);
                $('.overlay-7').css('margin-left', i7);
                if (i7 == wave_low7) {
                    flag7 = true;
                }
                ;
            }
        }
    }, w_speed7);
}
function float_bubble8(ele8, wave8, w_speed8, from8, to8, f_t_speed8, first_position) {

    var $this8 = $(ele8); //The element for action put on
    i8 = 0; // Wave possition default
    wave_high8 = wave8; // High Wave
    wave_low8 = -wave8; // Low wave
    flag8 = true; // Flag condition to reverse wave
    bottom8 = from8; // Starting bottom Possition
    up_speed8 = f_t_speed8; // Speed of going up
    default_pos8 = first_position;
    fillBubble(8);

    setInterval(function() { // Up 	
        if (pause8 != true) {
            $this8.css('top', default_pos8);
            $('.overlay-8').css('top', default_pos8);
            default_pos8-=bbupstep;
            if (default_pos8 == to8) {
                fillBubble(8);
                default_pos8 = bottom8;
            }
        }
    }, up_speed8);

    setInterval(function() { // Wave
        if (pause8 != true) {
            if (flag8 == true) {
                $('#js-move-8').css('margin-right', i8);
                $('.overlay-8').css('margin-right', i8);
                //$('#test').html(i8);
                i8++;
                if (i8 == wave_high8) {
                    flag8 = false;
                }
                ;
            } else {
                //$('#test').html(i8);
                $('#js-move-8').css('margin-right', i8);
                $('.overlay-8').css('margin-right', i8);
                i8--;
                if (i8 == wave_low8) {
                    flag8 = true;
                }
                ;
            }
        }
    }, w_speed8);
}
function float_bubble9(ele9, wave9, w_speed9, from9, to9, f_t_speed9, first_position) {

    var $this9 = $(ele9); //The element for action put on
    i9 = 0; // Wave possition default
    wave_high9 = wave9; // High Wave
    wave_low9 = -wave9; // Low wave
    flag9 = true; // Flag condition to reverse wave
    bottom9 = from9; // Starting bottom Possition
    up_speed9 = f_t_speed9; // Speed of going up
    default_pos9 = first_position;
    fillBubble(9);

    setInterval(function() { // Up 	
        if (pause9 != true) {
            $this9.css('bottom', default_pos9);
            $('.overlay-9').css('bottom', default_pos9);
            default_pos9+=bbupstep;
            if (default_pos9 == to9) {
                fillBubble(9);
                default_pos9 = bottom9;
            }
        }
    }, up_speed9);

    setInterval(function() { // Wave
        if (pause9 != true) {
            if (flag9 == true) {
                i9++;
                $('#js-move-9').css('margin-right', i9);
                $('.overlay-9').css('margin-right', i9);
                if (i9 == wave_high9) {
                    flag9 = false;
                }
                ;
            } else {
                i9--;
                $('#js-move-9').css('margin-right', i9);
                $('.overlay-9').css('margin-right', i9);
                if (i9 == wave_low9) {
                    flag9 = true;
                }
                ;
            }
        }
    }, w_speed9);
}

//<!------------------------ - CONTROLLS ----------------------------!>
// SPEED CONTROll - 400PX BUBBLE
float_bubble1("#js-move-1", 50, 100, -350, 800, 20, 500);  //minus //****
////// 320PX BUBBLE
float_bubble6("#js-move-6", 50, 80, 700, -300, 50, 300);
float_bubble7("#js-move-7", 80, 150, -350, 700, 30, -350);  //minus
float_bubble8("#js-move-8", 50, 85, 700, -300, 20, 700);
float_bubble9("#js-move-9", 55, 100, -350, 700, 25, -350);  //minus
////// 244PX BUBBLE
float_bubble2("#js-move-2", 40, 80, 700, -170, 50, 700);
float_bubble3("#js-move-3", 60, 90, -350, 750, 40, -350);   //minus
float_bubble4("#js-move-4", 80, 100, 850, -300, 30, 450);
float_bubble5("#js-move-5", 50, 100, 700, -270, 40, 200);



/**
 **** To change or controll bubble's behavior follow the instruction
 
 1) float_bubble1("#js-move-1",50,100,-350,800,20); - The function
 
 2) float_bubble1(      - Split the function and controlls
 "#js-move-1",  - The element 
 50,            - Side wave depth    !Note: Bubble becomes slow when the speed number increase.
 100,           - Side wave move speed  
 -350,          - Starting possition. !Note: Few have minus value, Change/Give the value in minus.
 800,           - Ending possition. !Note: Few have minus value, Change/Give the value in minus.
 20             - This value changes the up-speed of the bubble. !Note: Bubble becomes slow when the speed number increase.
 );
 
 3) After changing the value save the file and refresh the index.html page.
 
 4) Done.
 
 **/

var totalBubblesTwitter = 5;
var totalBubblesFacebook = 4;
var bubbleFacebookArray = [];
var bubbleTwitterArray = [];
var bubbleOverallArray = [];

function fillTwitterBubble(tweet, currentBubbleIndex) {

    if (tweet.imageURL == '') {
        $('#text-only p').html(tweet.tweetText);
        $("#text-only").clone().attr('id', '').appendTo("#flt-" + currentBubbleIndex + " .bubble_wrapper");
    }
    else {
        if (currentBubbleIndex > 1 && currentBubbleIndex <= 6)
        {
            $('#image-only img').attr('src', tweet.imageURL);
            $("#image-only").clone().attr('id', '').appendTo("#flt-" + currentBubbleIndex + " .bubble_wrapper");
        } else {
            $('#image-text p').html(tweet.tweetText);
            $('#image-text img').attr('src', tweet.imageURL);
            $("#image-text").clone().attr('id', '').appendTo("#flt-" + currentBubbleIndex + " .bubble_wrapper");
        }
    }

    $("#flt-" + currentBubbleIndex).find('.isFixed').val(tweet.fixed);
}

function cleanTwitterContent(currentBubbleIndex) {
    $('#twitter_template').find('.title').html('');
    $('#twitter_template').find('.sub-title').html('');
    $('#twitter_template').find('.title-y').html('');

    $(".overlay-" + currentBubbleIndex + "-details").empty();
}

function convertDate(inputFormat) {
    var d = new Date();
    var curr_date = d.getDate();
    var curr_month = d.getMonth() + 1; //Months are zero based
    var curr_year = d.getFullYear();
    return curr_date + "-" + curr_month + "-" + curr_year;
}

function fillBubble(currentIndex) {

    if (bubbleOverallArray != undefined) {

        if (bubbleOverallArray.length == 0) {
            setTimeout(function() {
                fillBubble(currentIndex);
            }, 1000);
            getBubbles();
        } else {

            //Fixed entries must be present all the time
            if ($("#flt-" + currentIndex).find('.isFixed').val() != 'true') {
                var currentBubble = bubbleOverallArray.pop();

                $("#flt-" + currentIndex + " .bubble_wrapper").empty();

                if (currentBubble.typeSource == 'twitter') {
                    fillTwitterBubble(currentBubble, currentIndex);
                    fillTwitterContent(currentBubble, currentIndex);
                } else {
                    fillFacebookBubble(currentBubble, currentIndex);
                    fillFacebookContent(currentBubble, currentIndex);
                }
            }
        }
    }
}


function fillFacebookBubble(entry, currentBubbleIndex) {
    if (entry.pictureUrl == '') {
        $('#text-only p').html(entry.message);
        $("#text-only").clone().attr('id', '').appendTo("#flt-" + currentBubbleIndex + " .bubble_wrapper");
    }
    else {
        if (currentBubbleIndex > 1 && currentBubbleIndex <= 6)
        {
            $('#image-only img').attr('src', entry.pictureUrl);
            $("#image-only").clone().attr('id', '').appendTo("#flt-" + currentBubbleIndex + " .bubble_wrapper");
        } else {
            $('#image-text p').html(entry.message);
            $('#image-text img').attr('src', entry.pictureUrl);
            $("#image-text").clone().attr('id', '').appendTo("#flt-" + currentBubbleIndex + " .bubble_wrapper");
        }
    }

    $("#flt-" + currentBubbleIndex).find('.isFixed').val(entry.fixed);
}

function fillTwitterContent(tweet, currentBubbleIndex) {

    cleanTwitterContent(currentBubbleIndex);

    //Clone
    $('#twitter_template').find('.title').html(tweet.screenName);
    var creationDate = convertDate(tweet.created);
    $('#twitter_template').find('.sub-title').html( creationDate);//'images/arrow.jpg ' +
    $('#twitter_template').find('.title-y').html(tweet.tweetText);

    if (tweet.imageURL != '') {
        $('#twitter_template').find('.twitter').addClass('twitter_image_special');
        $('#twitter_template').find('.image-div').show();
        $('#twitter_template').find('.image-div img').attr('src', tweet.imageURL);
    } else {
        $('#twitter_template').find('.twitter').removeClass('twitter_image_special');
        $('#twitter_template').find('.image-div').hide();
    }

    $("#twitter_template").clone().attr('id', currentBubbleIndex + '_bubble_content').appendTo(".overlay-" + currentBubbleIndex + "-details");
}

function cleanFacebookContent(currentBubbleIndex) {
    $('#facebook_template').find('.sub-heading').html('');
    $('#facebook_template').find('.body_text span').html('');

    $(".overlay-" + currentBubbleIndex + "-details").empty();
}

function fillFacebookContent(entry, currentBubbleIndex) {

    cleanFacebookContent(currentBubbleIndex);

    //Clone
    var creationDate = convertDate(entry.created);
    $('#facebook_template').find('.sub-heading').html(creationDate);

    $('#facebook_template').find('.body_text span').html(entry.message);

    if (entry.pictureUrl != '') {
        $('#facebook_template').find('.facebook-post').attr('src', entry.pictureUrl);
    }

    $("#facebook_template").clone().attr('id', currentBubbleIndex + '_bubble_content').appendTo(".overlay-" + currentBubbleIndex + "-details");

}

function fillBubbleAuxArray() {

    for (var i = 0; i < (bubbleTwitterArray.length + bubbleFacebookArray.length); i++) {

        if (bubbleFacebookArray.length == 0) {
            for (var j = 0; j < bubbleTwitterArray.length; j++) {

                if (!bubbleTwitterArray[j].wasFilled) {
                    bubbleTwitterArray[j].typeSource = 'twitter';
                    bubbleOverallArray.push(bubbleTwitterArray[j]);
                    bubbleTwitterArray[j].wasFilled = true;
                    break;
                }
            }
        } else if (bubbleTwitterArray.lenth == 0) {
            for (var j = 0; j < bubbleFacebookArray.length; j++) {
                if (!bubbleFacebookArray[j].wasFilled) {
                    bubbleFacebookArray[j].typeSource = 'facebook';
                    bubbleOverallArray.push(bubbleFacebookArray[j]);
                    bubbleFacebookArray[j].wasFilled = true;
                    break;
                }
            }
        } else {
            if (i % 2 == 0) {
                for (var j = 0; j < bubbleTwitterArray.length; j++) {

                    if (!bubbleTwitterArray[j].wasFilled) {
                        bubbleTwitterArray[j].typeSource = 'twitter';
                        bubbleOverallArray.push(bubbleTwitterArray[j]);
                        bubbleTwitterArray[j].wasFilled = true;
                        break;
                    }
                }
            } else {
                for (var j = 0; j < bubbleFacebookArray.length; j++) {
                    if (!bubbleFacebookArray[j].wasFilled) {
                        bubbleFacebookArray[j].typeSource = 'facebook';
                        bubbleOverallArray.push(bubbleFacebookArray[j]);
                        bubbleFacebookArray[j].wasFilled = true;
                        break;
                    }
                }
            }
        }


    }

    for (var i = 0; i < (totalBubblesTwitter + totalBubblesFacebook); i++) {
        fillBubble(i + 1);
    }
}

function fillArrayBubbles(data) {
    bubbleFacebookArray = data.facebookEntries;
    bubbleTwitterArray = data.tweets;
}

function getBubbles() {

    $.ajax({
        type: "GET",
        url: "http://socialbubbleapi.ubiquotechs.com/api/entries",
        jsonp: "callback",
        contentType: "application/json",
        dataType: "json",
        crossDomain: true,
        headers: {'Access-Control-Allow-Origin': '*'},
        success: function(response) {
            fillArrayBubbles(response);
            fillBubbleAuxArray();

        },
        error: function(response) {
            console.log(response);
        }
    });
}


$(document).ready(function() {
    getBubbles();
});

//Object wath property
if (!Object.prototype.watch) {
    Object.defineProperty(Object.prototype, "watch", {
        enumerable: false
        , configurable: true
        , writable: false
        , value: function(prop, handler) {
            var
                    oldval = this[prop]
                    , newval = oldval
                    , getter = function() {
                        return newval;
                    }
            , setter = function(val) {
                oldval = newval;
                return newval = handler.call(this, prop, oldval, val);
            }
            ;

            if (delete this[prop]) { // can't watch constants
                Object.defineProperty(this, prop, {
                    get: getter
                    , set: setter
                    , enumerable: true
                    , configurable: true
                });
            }
        }
    });
}

// object.unwatch
if (!Object.prototype.unwatch) {
    Object.defineProperty(Object.prototype, "unwatch", {
        enumerable: false
        , configurable: true
        , writable: false
        , value: function(prop) {
            var val = this[prop];
            delete this[prop]; // remove accessors
            this[prop] = val;
        }
    });
}