ロギングとプロファイリング
==========================

このエクステンションでは、送信された HTTP リクエストのロギングと、その実行のプロファイリングが可能です。
ログ・ターゲットをセットアップして、HTTP リクエストに関係する全てのエントリを捕捉するためには、`yii\httpclient\Transport*` というカテゴリを使用しなければなりません。
例えば、

```php
return [
    // ...
    'components' => [
        // ...
        'log' => [
            // ...
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'logFile' => '@runtime/logs/http-request.log',
                    'categories' => ['yii\httpclient\*'],
                ],
                // ...
            ],
        ],
    ],
];
```

[HTTP クライアント DebugPanel] を使って全ての関連するログを見ることも出来ます。

> 注意: HTTP リクエストのコンテントには非常に長いものがあるため、それをログの中に全部保存するとなると、何らかの問題が生じる可能性があります。
  このため、ログに記録されるリクエスト・コンテントの最大長に対しては、制限が設けられています。
  コンテントの最大長は [[\yii\httpclient\Client::contentLoggingMaxSize]] によって制御され、
  これを超えるコンテントはすべてロギングの前に切り詰められます。
