Использование отладочной панели HTTP-клиента
================================

Расширение Yii 2 HTTP Client предоставляет панель отладки, которая может быть интегрирована с модулем Yii 2 Debug
и отображать выполненные HTTP-запросы.

Добавьте код ниже в конфигурацию вашего приложения, чтобы включить её (если у вас уже включён модуль Debug, 
то достаточно просто добавить конфигурацию панелей):

```php
    // ...
    'bootstrap' => ['debug'],
    'modules' => [
        'debug' => [
            'class' => 'yii\\debug\\Module',
            'panels' => [
                'httpclient' => [
                    'class' => 'yii\\httpclient\\debug\\HttpClientPanel',
                ],
            ],
        ],
    ],
    // ...
```

Эта панель позволяет добавить в логи выполненный HTTP-запрос, чтобы увидеть его ответ. Вы можете получить ответ 
в виде строки или передать его непосредственно в браузер.

> Note: только обычные добавленные в лог HTTP-запросы могут быть выведены в панель отладки, запросы, отправляемые в пакетном режиме - не могут.
  Также, имейте ввиду, что содержимое добавленного в журнал запроса может быть обрезано, в соответствии с [[\yii\httpclient\Client::$contentLoggingMaxSize]],
  поэтому при его выполнении может произойти сбой или привести к неожиданным результатам.
