Журналирование и профилирование
=====================

Это расширение позволяет регистрировать отправленные HTTP-запросы и профилировать их выполнение.
Для настройки целевого журнала, который может захватить все записи, связанные с HTTP-запросами, вам следует 
использовать категорию `yii\httpclient\Transport*`. Например:

```php
return [
    // ...
    'components' => [
        // ...
        'log' => [
            // ...
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'logFile' => '@runtime/logs/http-request.log',
                    'categories' => ['yii\httpclient\*'],
                ],
                // ...
            ],
        ],
    ],
];
```

Вы также можете использовать [отладочную панель HTTP-клиента](topics-debug.md) для просмотра всех связанных журналов.

> Attention: поскольку содержимое некоторых HTTP-запросов может быть очень длинным, то сохранение его в полном объеме 
  может привести к определенным проблемам. Таким образом, существует ограничение на максимальную длину содержимого запроса,
  помещаемого в журнал. Это контролируется через [[\yii\httpclient\Client::$contentLoggingMaxSize]].
  При любом превышении длины содержимого оно будет обрезано перед журналированием.
